
##Clean obstacles and projectile from old game
function astro_game:game/clean

##Spaceship scoreboards
function astro_game:spaceship/setup/scoreboards

##Obstacles scoreboard
function astro_game:obstacles/setup/scoreboards


##Apply preset settings
execute if score preset astro_game.persistent matches 0 run function astro_game:obstacles/actions/spawning_presets/apply_preset/tutorial
execute if score preset astro_game.persistent matches 1 run function astro_game:obstacles/actions/spawning_presets/apply_preset/normal
execute if score preset astro_game.persistent matches 2 run function astro_game:obstacles/actions/spawning_presets/apply_preset/zen
execute if score preset astro_game.persistent matches 3 run function astro_game:obstacles/actions/spawning_presets/apply_preset/hard

##Set running state to true
scoreboard players set running astro_game.persistent 1

##Spawn tutorial window if needed
execute if score preset astro_game.persistent matches 0 run tag @e[tag=tutorial] remove animated_in


##Set in-game monitor
kill @e[tag=score_display]
data modify entity @e[tag=monitor,limit=1] item.components."minecraft:custom_model_data" set value {floats:[111]}
data modify entity @e[tag=buttons,limit=1] item.components."minecraft:custom_model_data" set value {floats:[112]}

##Start BGM
function astro_game:ambience/set_game_bgm

